/******************************************************************************/
#include "stdafx.h"
/******************************************************************************/
Material *brick,
         *glass;
Mesh      mbox ,
          mball;
Vec       pos[32];

Window   window;
Text    tbloom_org,
        tbloom_scale,
        tbloom_cut, 
        tbloom_overbright;
Slider   bloom_org,
         bloom_scale,
         bloom_cut;
CheckBox bloom_overbright;
/******************************************************************************/
void InitPre()
{
   App.name="Bloom configuration";
   App.flag=APP_FULL_TOGGLE;
   PakAdd("../data/engine.pak");

   D.full(true);
}
/******************************************************************************/
Bool Init()
{
   Cam.dist=3;

   brick=Materials("../data/mtrl/brick/0.mtrl");
   glass=Materials("../data/mtrl/glass/0.mtrl");

   mbox .create(1).B(0).create( Box(  4),VTX_TX0|VTX_NRM|VTX_TNG).reverse(); // create mesh box, reverse it because it's meant to be viewed from inside
   mball.create(1).B(0).create(Ball(0.5),VTX_TX0|VTX_NRM|VTX_TNG)          ; // create mesh ball

   // set mesh materials, rendering versions and bounding boxes
   mbox .setMaterial(brick).setRender().setBox();
   mball.setMaterial(glass).setRender().setBox();

   // set random positions inside box
   REPA(pos)pos[i]=Rnd(mbox.box);

   // add gui bloom controls
   Gui   +=window.create(Rect_C(0,-0.7,0.6,0.5),"Bloom Parameters");
   window+=tbloom_org       .create(Vec2(0.13,-0.08),"Origin"     ); window+=bloom_org       .create(Rect_C(0.1+window.crect.w()/2,-0.08,0.25,0.05),D.bloomOriginal  ());
   window+=tbloom_scale     .create(Vec2(0.13,-0.16),"Scale"      ); window+=bloom_scale     .create(Rect_C(0.1+window.crect.w()/2,-0.16,0.25,0.05),D.bloomScale     ());
   window+=tbloom_cut       .create(Vec2(0.13,-0.24),"Cutoff"     ); window+=bloom_cut       .create(Rect_C(0.1+window.crect.w()/2,-0.24,0.25,0.05),D.bloomCut       ());
   window+=tbloom_overbright.create(Vec2(0.13,-0.32),"OverBright" ); window+=bloom_overbright.create(Rect_C(0.1+window.crect.w()/2,-0.32,0.05,0.05),D.bloomOverbright());

   return true;
}
/******************************************************************************/
void Shut()
{
}
/******************************************************************************/
Bool Main()
{
   if(Kb.bp(KB_ESC))return false;
   Gui.update();

   Cam.setSpherical(Vec(0,0,0),Tm.time()/16,-0.3,0,3).updateVelocities().set(); // set autorotating camera

   D.bloom(bloom_org(),bloom_scale(),bloom_cut(),bloom_overbright()); // set bloom parameters

   return true;
}
/******************************************************************************/
void Render()
{
   switch(Renderer())
   {
      case RM_SOLID:
         mbox.draw(MatrixIdentity);
         REPA(pos)
         {
            glass->color.v3=ColorVec(ColorHue(Flt(i)/ELMS(pos)));
            mball.draw(Matrix(pos[i]));
         }
      break;

      case RM_LIGHT:
         LightPoint(25,Vec(0,3,0)).add();
      break;
   }
}
void Draw()
{
   Renderer(Render);
   Gui.draw();
}
/******************************************************************************/
